
# -*- coding: UTF-8 -*-

import os,re,time,json


def deldir(dirpath):
    f_list = os.listdir(dirpath)
    for f in f_list:
        filepath = os.path.join(dirpath, f)
        if os.path.isfile(filepath):
            os.remove(filepath)
        else:
            deldir(filepath)
    os.rmdir(dirpath)


def isbar(str):
    try:
        str2 = re.match(r'[a-z0-9_]*', str).group(0)
    except:
        str2 = None
    if(len(str) <= 14 and str2 == str):
        return True
    else:
        return False



def mkfunc(path, commands):
    file = open(path, 'w')
    line = 0
    while True:
        try:
            str = commands[line]
            file.write(str + '\n')
        except:
            break
        line += 1
    file.close()


def addfunc(path, command):
    file = open(path, 'a')
    file.write(command + '\n')
    file.close()


def mkmcmeta(path, line):
    file = open(path, 'w')
    file.write(line + '\n')
    file.close()



# deldir("E:\\das\\1.12.2基础整合包\\.minecraft\\versions\\1.16.4\\saves\\新的世界 (5)\\datapacks\\s3_bossbarsV0.1\\data\\bossbars\\functions\\"+"hhh")


# 改变目录到functions下
if not os.path.exists(os.getcwd() + "\\data\\bossbars\\functions"):
    os.makedirs(os.getcwd() + "\\data\\bossbars\\functions")
    print("已创建data文件夹")
if not os.path.exists(os.path.join(os.getcwd(), 'pack.mcmeta')):
    line = str(json.dumps(
        {
            "pack": {
                "author": "sch246",
                "MCBBS": "https://www.mcbbs.net/home.php?mod=space&uid=740479",
                "bilibili": "https://space.bilibili.com/172818145",
                "JE_id": "sch233",
                "pack_format": 6,
                "description": {"text": "sch233's_basic", "color": "green"}
            }
        }, sort_keys=True, indent=4
    ))
    mkmcmeta(os.path.join(os.getcwd(), 'pack.mcmeta'), line)
    print("已创建mcmeta文件")
os.chdir(os.getcwd()+"\\data\\bossbars\\functions")


# 设置名字
while True:
    bar_name = input("设置bossbar的名字: ")
    if isbar(bar_name) == True:
        print("bossbar名字是: "+bar_name)
        break
    else:
        print("仅接受小写字母,数字和下划线,长度不超过14")
        time.sleep(1)
        pass
# 重置确认
if os.path.exists(bar_name):
    check = input('已存在文件夹,输入\"yes\"确定重置文件夹: ')
    if check == "yes":
        deldir(os.path.join(os.getcwd(), bar_name))
        print("已删除 "+bar_name+" 文件夹及其下所有内容")
    else:
        input("按任意键退出...")
        os._exit(0)


# 设置数量
while True:
    maxcount = None
    try:
        maxcount = int(input("输入玩家数量: "))
    except:
        print("请输入数字!")
        time.sleep(1)
        pass
    if type(maxcount) == int:
        break
muti_2 = 2
while muti_2 < maxcount:
    muti_2 *= 2
maxcount = muti_2
print("最大数量将设置为:" + str(maxcount))


# 改变路径
os.mkdir(bar_name)
os.chdir(bar_name)
funcpath = f"bossbars:{bar_name}"

# 生成add
print("生成"+'add.mcfunction')
commands = [
    f"scoreboard players add #bossbars -{bar_name}- 1",
    f"scoreboard players operation @s -{bar_name}- = #bossbars -{bar_name}-"
]
mkfunc('add.mcfunction',commands)


# 生成reset
print("生成"+'reset.mcfunction')
commands = [
    f"scoreboard objectives remove -{bar_name}-",
    f"scoreboard objectives add -{bar_name}- dummy"
]
mkfunc('reset.mcfunction', commands)
# 循环穷举
for count in range(1,maxcount+1):
    addfunc('reset.mcfunction', f"bossbar remove {bar_name}_{count}")


# 生成set
# 先算出要几条下划线
temp = maxcount
str_ = ''
maxlayer = 0
while (not temp == 1):
    temp /= 2
    str_ = str_ + '_'
    maxlayer += 1
    if maxlayer >= 31:
        input("循环超出限制,按任意键退出...")
        os._exit(0)
# 生成
print("生成"+'set.mcfunction')
commands = [
    f"execute unless score @s -{bar_name}- matches 1.. run function {funcpath}/add",
    f"function bossbars:{bar_name}/bars/{str_}{maxcount}\n"
]
mkfunc('set.mcfunction', commands)


# 改变路径
os.mkdir('bars')
os.chdir('bars')
funcpath = funcpath + "/bars"


# 先定义下缩写
ifdata = 'execute if data'
run = ' run '
storage_bar = ' storage bossbars ' + bar_name


# 生成第一波函数
for count in range(1, maxcount+1):
    print("生成" + str(count) + '.mcfunction')
    commands = [
    '# add bossbar',
        f'bossbar add {bar_name}_{count} ""' + '\n',
    '# color',
        ifdata + storage_bar + '.color' +
        run + 'function ' + funcpath + f'/{count}_color' + '\n',
    '# style',
        ifdata + storage_bar + '.style' +
        run + 'function ' + funcpath + f'/{count}_style' + '\n',
    '# name',
        ifdata + storage_bar + '.name' +
        run + f'bossbar set {bar_name}_{count} name ' + 
            str(json.dumps({
                "storage": "bossbars",
                "nbt": bar_name + ".name", 
                "interpret":True
            }))
            + '\n',
    '# visible',
        ifdata + storage_bar + '{visible: 0b}' +
        run + f'bossbar set {bar_name}_{count} visible false',
        ifdata + storage_bar + '{visible: 1b}' +
        run + f'bossbar set {bar_name}_{count} visible true' + '\n',
    '# value',
        ifdata + storage_bar + '.value' +
        f' store result bossbar {bar_name}_{count} ' + 'value' +
        run + f'data get storage bossbars {bar_name}.value' + '\n',
    '# max',
        ifdata + storage_bar + '.max' +
        f' store result bossbar {bar_name}_{count} ' + 'max' +
        run + f'data get storage bossbars {bar_name}.max' + '\n\n',

        f'bossbar set {bar_name}_{count} players @s'
    ]
    mkfunc(str(count) + '.mcfunction', commands)

    print("生成" + str(count) + '_color.mcfunction')
    commands = [
    ]
    colors = ['blue', 'green', 'pink', 'purple', 'red', 'white', 'yellow']
    for color in colors:
        commands.append(ifdata + storage_bar +
                        '{color: "' + color + '"}' + run + f'bossbar set {bar_name}_{count} color '+ color)
    mkfunc(str(count) + '_color.mcfunction', commands)

    print("生成" + str(count) + '_style.mcfunction')
    commands = [
    ]
    styles = ['progress', 'notched_6', 'notched_10', 'notched_12', 'notched_20']
    for style in styles:
        commands.append(ifdata + storage_bar +
                        '{style: "' + style + '"}' + run + f'bossbar set {bar_name}_{count} style ' + style)
    mkfunc(str(count) + '_style.mcfunction', commands)


# 先定义下缩写
exe_if_scb_match = f'execute if score @s -{bar_name}- matches '
runf = f' run function {funcpath}/'


layer = 1
# str_ = maxlayer 个 '_'
str_ = ''
while layer <= maxlayer:
    d_count = 2 ** layer
    count = d_count
    while count <= maxcount:
        half_d = d_count // 2
        if d_count == 2:
            range1 = str(count - d_count + 1)
            range2 = str(count)
        else:
            range1 = str(count - d_count + 1)+'..'+str(count - half_d)
            range2 = str(count - half_d + 1)+'..'+str(count)
        funcname = str_ + '_' + str(count) + '.mcfunction'
        print('生成' + funcname)
        commands = [
            exe_if_scb_match + range1 + runf + str_ + str(count - half_d),
            exe_if_scb_match + range2 + runf + str_ + str(count)
        ]
        mkfunc(funcname, commands)
        count += d_count
    str_ = '_'+str_
    layer += 1


input('按任意键退出...')
