# 字符串切片，start和end是可选的，支持负数(mc本身就支持)，会判断字符串长度和索引位置，不会有超出索引的错误，若end<=start，返回空字符串，若需要更高的性能，使用s3:string/slice/_raw
# 会破坏输入
#
# 用法:
#   data modify storage : input set value {str:"...",start:12,end:34}
#   function s3:string/slice
# 输出:
#   data get storage : result

# 字符串长度
execute store result score #len tmp run data get storage : input.str

# 当不输入start时默认为0
execute unless data storage : input.start run data modify storage : input.start set value 0
# 当不输入end时默认为字符串长度
execute unless data storage : input.end store result storage : input.end int 1 run scoreboard players get #len tmp

# 读取start和end
execute store result score #start tmp run data get storage : input.start
execute store result score #end tmp run data get storage : input.end

# 负号转正
execute if score #start tmp matches ..-1 run scoreboard players operation #start tmp += #len tmp
execute if score #end tmp matches ..-1 run scoreboard players operation #end tmp += #len tmp

# 若超出上下限则归一下
execute if score #start tmp matches ..-1 run data modify storage : input.start set value 0
execute if score #start tmp matches ..-1 run scoreboard players set #start tmp 0
execute if score #end tmp > #len tmp store result storage : input.end int 1 run scoreboard players get #len tmp
execute if score #end tmp > #len tmp run scoreboard players operation #end tmp = #len tmp

# 相互错开则返回空字符串(相等的话，mc本身返回空字符串)
data modify storage : result set value ""
execute if score #end tmp < #start tmp run return 1
function s3:string/slice/_raw
