#sch233

from os import chdir, listdir
import json

rootpath = 'data/vimi/'
funcpath = 'functions/'
tagpath = 'tags/blocks/'
mcf_end = '.mcfunction'
json_end = '.json'


def funcAdd(path,str):
    '''path从vimi/functions/下算起'''
    with open(rootpath + funcpath + path + mcf_end, 'a',encoding='utf-8') as f:
        f.write('\n'+str)

def tagAdd(str):
    filepath = rootpath + tagpath + 'single_state.json'
    with open(filepath,'r+',encoding='utf-8') as f:
        J = json.loads(f.read())
        if str in J['values']:
            return False
        J['values'].append(str)
    with open(filepath,'w',encoding='utf-8') as f:
        f.write(json.dumps(J,indent=4))
    return True

def want(text, check, err, p=lambda x: x):
    while 1:
        get = p(input(text+'\n> '))
        if check(get):
            return get
        else :
            print(err)

def toScb(str):
    return ''.join([w.capitalize() for w in str.split('_')])

print('本脚本只提供添加方块(原版)的功能')

def find_data(get):
    chdir(get)
    return 'data' in listdir()

if 'data' in listdir(): print('已检测到data文件夹!')
else:want('请输入数据包路径',find_data,'路径下没有data文件夹!')

mode_list = ['方块','方块标签']
tool_list = ['','斧','锄','镐','剪','铲']
tool_list_en = ['','axe','hoe','pickaxe','shears','shovel']

while 1:
    match_tool = want('1:斧 2:锄 3:镐 4:剪 5:铲 选择工具类型...',lambda x:x in [1,2,3,4,5],'请输入1..5',int)
    block = want('输入方块id(例如 stone)...',lambda x:x,'输入不能为空')
    block=block.replace('minecraft:','')

    if input(f'工具类型是:{tool_list[match_tool]},方块id是:minecraft:{block},再次enter确认,否则输入任意字符并enter\n> ') != '' : continue
    
    if not tagAdd(block):
        print(f'{str}已在标签内!')
        continue
    
    scbname = toScb(block)
    funcAdd('load',f'scoreboard objectives add vimi{scbname} mined:{block}')
    funcAdd('reset_score',f'scoreboard players reset * vimi{scbname}')
    funcAdd(f'clone_block/{tool_list_en[match_tool]}',f'execute if score @s vimi{scbname} matches 1.. run setblock 20000016 1 20000016 {block}')
    
    
    
    if input(f'再次enter以继续添加方块,否则输入任意字符并enter\n> ') != '' : exit()
