/*
 * Decompiled with CFR 0.152.
 */
package com.sch246.command_craft.mixin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.sch246.command_craft.IUuidData;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2105;
import net.minecraft.class_2168;
import net.minecraft.class_2203;
import net.minecraft.class_2280;
import net.minecraft.class_2300;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4565;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2300.class})
public abstract class EntitySelectorMixin
implements IUuidData {
    @Shadow
    @Mutable
    @Final
    private UUID field_10821;
    @Shadow
    private Function<class_243, class_243> field_10823;
    @Unique
    private String uuidData;

    @Shadow
    private void method_9818(class_2168 source) throws CommandSyntaxException {
    }

    @Shadow
    @Nullable
    private class_238 method_61160(class_243 offset) {
        return null;
    }

    @Shadow
    private Predicate<class_1297> method_9817(class_243 pos, @Nullable class_238 box, @Nullable class_7699 enabledFeatures) {
        return null;
    }

    @Override
    public String getUuidData() {
        return this.uuidData;
    }

    @Override
    public void setUuidData(String uuidData) {
        this.uuidData = uuidData;
    }

    @Inject(at={@At(value="HEAD")}, method={"getEntities"}, cancellable=true)
    public void onGetEntities(class_2168 source, CallbackInfoReturnable<List<? extends class_1297>> cir) throws CommandSyntaxException {
        this.method_9818(source);
        if (this.uuidData != null) {
            this.field_10821 = this.getUUIDFromUuidData(source, this.uuidData);
            System.out.println("getUUIDFromUuidData: " + String.valueOf(this.field_10821));
            if (this.field_10821 == null) {
                cir.setReturnValue(List.of());
            } else {
                for (class_3218 serverWorld : source.method_9211().method_3738()) {
                    class_1297 entity = serverWorld.method_14190(this.field_10821);
                    if (entity == null) continue;
                    List<class_1297> candidates = List.of(entity);
                    List<class_1297> filtered = this.applyOtherFilters(candidates, source);
                    cir.setReturnValue(filtered);
                    break;
                }
            }
            cir.cancel();
        }
    }

    @Nullable
    private UUID getUUIDFromUuidData(class_2168 source, String uuidData) throws CommandSyntaxException {
        System.out.println("\nuuidData: " + uuidData);
        class_2520 nbtElement = this.getDataSourceNbt(source, uuidData);
        System.out.println("\nnbtElement: " + String.valueOf(nbtElement));
        if (nbtElement instanceof class_2495) {
            class_2495 intArray = (class_2495)nbtElement;
            int[] values = intArray.method_10588();
            if (values.length == 4) {
                long most = (long)values[0] << 32 | (long)values[1] & 0xFFFFFFFFL;
                long least = (long)values[2] << 32 | (long)values[3] & 0xFFFFFFFFL;
                return new UUID(most, least);
            }
        } else {
            if (nbtElement instanceof class_2519) {
                class_2519 string = (class_2519)nbtElement;
                return UUID.fromString(string.method_10714());
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.data.get.invalid")).create();
        }
        return null;
    }

    public class_2520 getDataSourceNbt(class_2168 source, String dataSourceString) throws CommandSyntaxException {
        String type;
        String fullCommand = "data get " + dataSourceString;
        CommandDispatcher dispatcher = source.method_9211().method_3734().method_9235();
        ParseResults parseResults = dispatcher.parse(fullCommand, (Object)source);
        CommandContextBuilder builder = parseResults.getContext();
        List nodes = builder.getNodes();
        CommandNode typeNode = ((ParsedCommandNode)nodes.get(2)).getNode();
        if (!(typeNode instanceof LiteralCommandNode)) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.data.get.invalid")).create();
        }
        class_2203.class_2209 nbtPath = (class_2203.class_2209)((ParsedArgument)builder.getArguments().get("path")).getResult();
        switch (type = ((LiteralCommandNode)typeNode).getLiteral()) {
            case "entity": {
                System.out.println("\n\nentity: " + this.uuidData);
                class_2300 selector = (class_2300)((ParsedArgument)builder.getArguments().get("target")).getResult();
                class_1297 entity = selector.method_9809(source);
                class_2487 nbtCompound = class_2105.method_9076((class_1297)entity);
                return EntitySelectorMixin.getNbt(nbtPath, nbtCompound);
            }
            case "storage": {
                System.out.println("\n\nstorage: " + this.uuidData);
                class_2960 id = (class_2960)((ParsedArgument)builder.getArguments().get("target")).getResult();
                class_4565 storage = source.method_9211().method_22827();
                class_2487 storageNbt = storage.method_22546(id);
                return EntitySelectorMixin.getNbt(nbtPath, storageNbt);
            }
            case "block": {
                System.out.println("\n\nblock: " + this.uuidData);
                System.out.println("\n\ntype: " + String.valueOf(((ParsedArgument)builder.getArguments().get("targetPos")).getResult().getClass()));
                class_2280 posArg = (class_2280)((ParsedArgument)builder.getArguments().get("targetPos")).getResult();
                System.out.println("\n\nposArg: " + String.valueOf(posArg));
                class_2338 pos = posArg.method_9704(source);
                System.out.println("\n\npos: " + String.valueOf(pos));
                class_2586 blockEntity = source.method_9225().method_8321(pos);
                System.out.println("\n\nblockEntity: " + String.valueOf(blockEntity));
                if (blockEntity == null) {
                    System.out.println("\n\n\u6307\u5b9a\u4f4d\u7f6e\u6ca1\u6709\u65b9\u5757\u5b9e\u4f53");
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"\u6307\u5b9a\u4f4d\u7f6e\u6ca1\u6709\u65b9\u5757\u5b9e\u4f53")).create();
                }
                class_2487 blockNbt = blockEntity.method_38242((class_7225.class_7874)blockEntity.method_10997().method_30349());
                System.out.println("\n\nblockNbt: " + String.valueOf(blockNbt));
                return EntitySelectorMixin.getNbt(nbtPath, blockNbt);
            }
        }
        throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"\u5fc5\u987b\u4ee5entity,storage,block\u4e2d\u7684\u4e00\u4e2a\u5f00\u5934")).create();
    }

    private static class_2520 getNbt(class_2203.class_2209 path, class_2487 nbtCompound) throws CommandSyntaxException {
        List collection = path.method_9366((class_2520)nbtCompound);
        Iterator iterator = collection.iterator();
        class_2520 nbtElement = (class_2520)iterator.next();
        if (iterator.hasNext()) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.data.get.multiple")).create();
        }
        return nbtElement;
    }

    private List<class_1297> applyOtherFilters(List<class_1297> candidates, class_2168 source) {
        class_243 vec3d = this.field_10823.apply(source.method_9222());
        class_238 box = this.method_61160(vec3d);
        Predicate<class_1297> predicate = this.method_9817(vec3d, box, source.method_45549());
        return candidates.stream().filter(predicate).filter(e -> e.method_5864().method_45382(source.method_45549())).collect(Collectors.toList());
    }
}

