from PIL import Image
import os

path = os.path.join(os.path.dirname(__file__),'assets/floating/textures/font/bar.png')

# 生成蓝条图片
def generate_blue_bar(width, height, border_color, start_color, end_color):
    # 创建图片
    img = Image.new('RGB', (width, height*(width-1)), border_color)
    for i in range(width-1):
        for j in range(1, width-1):
            for k in range(1, height-1):
                h = i*height
                if j<i+1:
                    img.putpixel((j, k+h), start_color)
                else:
                    img.putpixel((j, k+h), end_color)

        # 保存图片
    img.save(path)

# 参数设置
width = 182
height = 5
border_color = (0, 104, 124)  # 深蓝色
start_color = (10, 181, 214)  # 浅蓝色
end_color = (0, 0, 0)  # 黑色

# 生成图片
generate_blue_bar(width, height, border_color, start_color, end_color)
