from PIL import Image
import os

path = os.path.join(os.path.dirname(__file__),'assets/floating/textures/font/bar2.png')

# 生成蓝条图片
def generate_blue_bar(width, height, end_color):
    # 创建图片
    img = Image.new('RGBA', (width, height*(width-1)),(0,0,0,0))
    for i in range(width-1):
        for j in range(1, width-1):
            for k in range(1, height-1):
                h = i*height
                if j>=width-i:
                    img.putpixel((j, k+h), end_color)

        # 保存图片
    img.save(path)

# 参数设置
width = 182
height = 5
end_color = (226, 186, 239,255)

# 生成图片
generate_blue_bar(width, height, end_color)
